/* 3dmerge  -  merge two 3d files */

/* Oscar Garcia <garciao@mof.govt.nz>, May 1992 */

#include <stdlib.h>
#include <stdio.h>

#define USAGE "usage: 3dmerge infile1 [infile2 [outfile]]\n\
\tIf file names are omitted, the standard i/o streams are used.\n"

#define ERROR(msg) {fputs(msg,stderr),exit(1);}
#define PERROR(msg) {perror(msg),exit(1);}


#define RECLEN 81

void main(int argc, char* argv[])
{
	int i, npoints1, npoints2, nlines1, nlines2, point, colour;
	char record[RECLEN + 1];
	FILE *input1, *input2 = stdin, *output = stdout;

	/* open files */
	if (argc < 2 || argc > 4)
		ERROR(USAGE);   /* wrong arguments */
	input1 = fopen(argv[1], "rt");
	if (input1 == NULL)
	{	fputs("Can't open first input file\n", stderr);
		ERROR(USAGE);
	}
	if (argc > 2)
	{	input2 = fopen(argv[2], "rt");
		if (input2 == NULL)
			ERROR("Can't open second input file");
	}
	if (argc > 3)
	{	output = fopen(argv[3], "wt");
		if (output == NULL)
			ERROR("Can't open output file");
	}

	/* numbers of points */
	fscanf(input1, "%d", &npoints1);
	fscanf(input2, "%d", &npoints2);
	if (ferror(input1) || ferror(input2))
		PERROR("Bad input file");
	fprintf(output, "%d\n", npoints1 + npoints2);

	/* copy points */
	fgets(record, RECLEN, input1);		/* skip rest of line */
	fgets(record, RECLEN, input2);
	for (i=0; i < npoints1; i++)
	{	fgets(record, RECLEN, input1);
		fputs(record, output);
	}
	for (i=0; i < npoints2; i++)
	{	fgets(record, RECLEN, input2);
		fputs(record, output);
	}

	/* numbers of lines */
	fscanf(input1, "%d", &nlines1);
	fscanf(input2, "%d", &nlines2);
	fprintf(output, "%d\n", nlines1 + nlines2);

	/* copy lines */
	for (i=0; i < nlines1; i++)
	{	fscanf(input1, "%d %d", &point, &colour);
		fprintf(output, "%d %d\n", point, colour);
	}
	if (feof(input1))
		ERROR("Unexpected end of file in first file");
	for (i=0; i < nlines2; i++)
	{	fscanf(input2, "%d %d", &point, &colour);
		fprintf(output, "%d %d\n", point + npoints1, colour);
	}
	if (feof(input2))
		ERROR("Unexpected end of file in second file");


	if (ferror(input1) || ferror(input2) || ferror(output))
		PERROR("i/o error");

}
